definition module ioState;

//	Version 0.8 to 1.0

import	events, controls;
import	timerDef, menuDef, windowDef, dialogDef, event;
from deltaIOSystem	import	::DeviceSystem, TimerSystem, MenuSystem,
								WindowSystem, DialogSystem,
								AppleEventSystem,::AppleEventSystemState,
								::AppleEventHandler(..);//,,OpenHandler,QuitHandler; ScrapChangedHandler;
from deltaPicture	import	::Point;

EmptyMacMenuHandle :== 0;

::	*IOState *s;

::	DeviceSystemState	*s	=	TimerSystemState	(TimerHandles	s)
							|	MenuSystemState		(MenuHandles	s)
							|	WindowSystemState	(WindowHandles	s)
							|	DialogSystemState	(DialogHandles	s)
							|	AppleEventSystemState (AppleEventSystemState s (IOState s));

::	TimerHandles		*s	:==	[TimerHandle s];
::	TimerHandle			*s	:==	(!TimerDef s (IOState s), !Time);
::	Time					:==	Int;

::	MenuHandles			*s	:==	(![MenuHandle s], ![Char], !MacMenuHandle, !Bool);
::	MenuHandle			*s
	= 	PullDownHandle		MacMenuHandle MenuId MenuId SelectState [MenuHandle s]
	| 	MenuItemHandle		MenuItemId Char (MenuFunction s (IOState s))
	| 	CheckMenuItemHandle	MenuItemId Char (MenuFunction s (IOState s))
	| 	SubMenuItemHandle	MacMenuHandle MenuId MenuId	[MenuHandle s]
	| 	MenuItemGroupHandle	MenuItemGroupId				[MenuHandle s]
	| 	MenuRadioItemsHandle							[MenuHandle s]
	| 	MenuSeparatorHandle;

::	WindowHandles		*s	:==	(![WindowHandle s], !GlobalCursor);
::	WindowHandle		*s	:==	(!WindowDef s (IOState s), !Window);
::	Window
	:==	(	!WindowPtr,
			!ScrollState,
			!ScrollState,
			!Int,
			!UpdateArea,
			!ZoomState	);
::	ScrollState
	:==	(	!ControlHandle,
			!Int,
			!Int		);
::	ZoomState
	:==	(	!Int,
			!Int		);
::	GlobalCursor
	=	GlobalCursorSet CursorShape
	|	NoGlobalCursor;
::	DoubleDownDist
	:==	Int;

::	DialogHandles		*s	:==	[DialogRep s (IOState s)];


::	Device
	=	TimerDevice | MenuDevice | WindowDevice | DialogDevice | AppleEventDevice ;

::	DeviceFunctions		*s
	:==	(	!ShowFunction	s,
			!OpenFunction	s,
			!DoIOFunction	s,
			!CloseFunction	s,
			!HideFunction	s	);

::	ShowFunction  *s :== (IOState s) -> IOState s;
::	OpenFunction  *s :== (DeviceSystem s (IOState s)) -> ((IOState s) -> IOState s);
::	DoIOFunction  *s :== Event -> (s -> *((IOState s) -> *(!Bool, !s, !IOState s)));
::	CloseFunction *s :== (IOState s) -> IOState s;
::	HideFunction  *s :== (IOState s) -> IOState s;


//	Access-rules on the IOState:

NewIOStateFromOld		:: !(IOState s) -> (!IOState t, !IOState s);
OldIOStateFromNew		:: !(IOState s) !(IOState t) -> IOState s;
EmptyIOState			:: !EVENTS -> IOState s;
IOStateEvents			:: !(IOState s) -> EVENTS;

IOStateButtonFreq		:: !Time !Point !WindowPtr !(IOState s) -> (!ButtonState, !IOState s);
IOStateSetDoubleDownDist:: !DoubleDownDist	 !(IOState s) -> IOState s;

IOStateClosed			:: !(IOState s)			-> (!Bool, !IOState s);
IOStateHasDevice		:: !(IOState s) !Device -> (!Bool, !IOState s);

IOStateGetAnyDevice		:: !(IOState s) -> (!DeviceSystemState s, !IOState s);
IOStateRemoveAnyDevice	:: !(IOState s) -> (!DeviceSystemState s, !IOState s);
IOStateRemoveDevice		:: !(IOState s) !Device -> IOState s;
IOStateGetDevice		:: !(IOState s) !Device -> (!DeviceSystemState s, !IOState s);
IOStateSetDevice		:: !(IOState s) !(DeviceSystemState s) -> IOState s;

IOStateGetWorld			:: !(IOState s) -> (!*World,!IOState s);
IOStateSetWorld			:: !*World !(IOState s) -> IOState s;

IOStateGetToolbox		::									!(IOState s) -> (!*Toolbox, !IOState s);
IOStateSetToolbox		:: !*Toolbox						!(IOState s) -> IOState s;
IOStateChangeToolbox	:: !(*Toolbox -> *Toolbox)			!(IOState s) -> IOState s;
IOStateAccessToolbox	:: !(*Toolbox -> (!x, !*Toolbox))	!(IOState s) -> (!x, !IOState s);


//	The priority of the Devices:

Priority :: !Device -> Int;
